unit uDuck;

interface

uses
    Classes, SysUtils;

function PickRandom( AList : array of Integer ) : Integer; overload;
function PickRandom( AList : TStrings ) : String; overload;
function RandomBetween( min, max : Integer) : Integer;

function  ExtractTo( var Source : String; S : String ) : String;
function  RandomZ( Idx : Integer) : Integer;
procedure FindFiles( Path : String; Attr : Integer; Strings : TStrings );
function  InBetween( N, L1, L2 : LongInt ) : Boolean;
procedure FreeObjectsFromList(AList : TList);


implementation

function PickRandom( AList : array of Integer ) : Integer;
var
    I, Sum : Integer;
begin
    Sum := 0;
    Result := Low (AList);
    for I := Low(AList) to High(AList) do
       Inc(Sum,AList[I]);
    Sum := Random(Sum);
    for I := Low(AList) to High(AList) do begin
       if AList[I]>Sum then begin
           Result := I;
           Exit;
       end;
       Dec(Sum,AList[I]);
    end;
end;

function PickRandom( AList : TStrings ) : String;
begin
    Result := AList[ Random(AList.Count) ];
end;


function RandomBetween( min, max : Integer) : Integer;{ Retourneert [ min..max-1 ] }
begin
    Result := Random((max - min)) + min;
end;

function  ExtractTo( var Source : String; S : String ) : String;
var
    I   : Word;
begin
    I := Pos( S, Source );
    if I = 0 then begin
        ExtractTo := Source;
        Source := '';
        EXIT;
    end;
    ExtractTo := Copy( Source, 1, I-1 );
    Delete( Source, 1, I+Length(S)-1 );
end {ExtractTo};

function RandomZ( Idx : Integer) : Integer;
begin
    if (Idx<=1) then begin
        Result := 0;
        Exit;
    end;
    if Idx=2 then
        Result :=1
    else
        Result := Random(Idx-1)+1;
    if Random(2)=0 then
        Result := - Result;
end;

procedure FindFiles( Path : String; Attr : Integer; Strings : TStrings );
var
    Found : Integer;
    SearchRec : TSearchRec;
begin
    Found := FindFirst(Path, Attr, SearchRec);
    while Found = 0 do begin
        Strings.Add( SearchRec.Name );
        Found := FindNext(SearchRec);
    end;
    FindClose(SearchRec);
end;

function  InBetween( N, L1, L2 : LongInt ) : Boolean;
begin
    InBetween := ((N>L1) and (N<L2)) or ((N>L2) and (N<L1));
end {InBetween};

procedure FreeObjectsFromList(AList : TList);
var
    I,J : Integer;
    O : TObject;
begin
    for I := 0 to AList.Count-1 do
        for J := 0 to I-1 do
             if AList[I] = AList[J] then begin
                 AList[I] :=nil;
                 Continue;
             end;
    while AList.Count <> 0 do begin
        O := AList[0];
        AList.Delete(0);
        if O<>nil then
            O.Free;
    end;
end;


end.
