unit uInfo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, uCreature, uDuck;

type
  TfrmInfo = class(TForm)
    Memo1: TMemo;
  private
    { Private declarations }
    FCreature : TCreature;
  public
    { Public declarations }
    constructor Create( AnOwner : TComponent;
                        ACreature : TCreature );
    procedure Update;
    procedure CreateParams(var Params: TCreateParams);
    property Creature : TCreature read FCreature;
  end;

var
  frmInfo: TfrmInfo;

implementation

uses
    Cambmain;

constructor TfrmInfo.Create( AnOwner : TComponent; ACreature : TCreature );
begin
    inherited Create(AnOwner);
    Parent := AnOwner as TForm;
    FCreature := ACreature;
    Visible := True;
end;

procedure TfrmInfo.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);
    Params.Style := Params.Style or WS_CHILD;
end;

procedure TfrmInfo.Update;
var
    AView : TView;
begin
    Memo1.Lines.Clear;
    Memo1.Lines.Add( 'Energy = '+FloatToStr(Creature.Energy) );
    AView := (Parent as TfrmCambrium).View;
    AView.dX := -Creature.XPos;
    AView.dY := -Creature.YPos;
    (Parent as TfrmCambrium).View := AView;
end;



{$R *.DFM}

end.
