unit fMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleServer, SpeechLib_TLB, ActiveX, WinAmpApi, StdCtrls, IniFiles;


const
    kwacPlay   = 'start playing';
    kwacStop   = 'stop playing';
    kwacPause  = 'pause';
    kwacVolUp  = 'turn up volume';
    kwacVolDn  = 'lower volume';
    kwacSelect = 'select';

const
    kVolumeSteps = 10;

type
  TForm1 = class(TForm)
    SpSharedRecoContext1: TSpSharedRecoContext;
    SpVoice1: TSpVoice;
    Memo1: TMemo;
    lblLastCommand: TLabel;
    butMicrofoon: TButton;
    butTrain: TButton;
    Label1: TLabel;
    Label2: TLabel;
    txtMP3s: TEdit;
    txtWinAmp: TEdit;
    butStart: TButton;
    procedure SpSharedRecoContext1Recognition(Sender: TObject;
      StreamNumber: Integer; StreamPosition: OleVariant;
      RecognitionType: TOleEnum; var Result: OleVariant);
    procedure FormDestroy(Sender: TObject);
    procedure butTrainClick(Sender: TObject);
    procedure butMicrofoonClick(Sender: TObject);
    procedure butStartClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FsSongDir : String;
    FIniFile : TIniFile;
    SRGrammar: ISpeechRecoGrammar;
    FWinAmp : TWinampApi;
    procedure Speak( Str : String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.butStartClick(Sender: TObject);
var
    slGrammar : TStringList;
    SR : TSearchRec;
    Res : Integer;

    procedure AddCommando( St : String );
    var
        i : Integer;
    begin
        St := LowerCase(St);
        St := 'eddie ' + St;
        // filter rare characters
        for i := 1 to length(St) do
            if not (St[i] in ['a'..'z',' ','0'..'9']) then
                Exit;

        slGrammar.Add('      <P>'+St+'</P>');
    end;
begin
    // stel knoppen in:
    butStart.Enabled := False;
    txtMP3s.Enabled := False;
    txtWinAmp.Enabled := False;
    butTrain.Enabled := True;
    butMicrofoon.Enabled := True;

    slGrammar := TStringList.Create;
    // voeg het begin van de grammatica toe,
    with slGrammar do begin
        Add('<GRAMMAR LANGID="809">');
        Add('');
        Add('    <DEFINE>');
        Add('        <ID NAME="RID_simple" VAL="1"/>');
        Add('    </DEFINE>');
        Add('');
        Add('    <RULE ID="RID_simple" TOPLEVEL="ACTIVE">');
        Add('        <L>');
    end;

    // voeg WinAmp commando's toe:
    AddCommando( kwacPlay );
    AddCommando( kwacStop );
    AddCommando( kwacPause );
    AddCommando( kwacVolUp );
    AddCommando( kwacVolDn );

    FsSongDir := txtMP3s.Text;
    if (Length(FsSongDir)>0) and (FsSongDir[Length(FsSongDir)]='\') then
        SetLength( FsSongDir, Length(FsSongDir)-1);
    Res := FindFirst( FsSongDir+'\*.*', faDirectory, SR );
    while Res = 0 do begin
        if (SR.Attr and faDirectory= faDirectory) and (SR.Name[1]<>'.') then
            AddCommando (kwacSelect + ' ' + SR.Name );
        Res := FindNext( SR );
    end;
    FindClose( SR );

    // voeg het einde van de grammatica toe,
    with slGrammar do begin
        Add('        </L>');
        Add('    </RULE>');
        Add('</GRAMMAR>');
    end;
    slGrammar.SaveToFile('Grammar.xml');
    slGrammar.Free;

    SpSharedRecoContext1.EventInterests := SREAllEvents;
    SRGrammar := SpSharedRecoContext1.CreateGrammar(0);
    SRGrammar.CmdLoadFromFile('Grammar.xml', SLODynamic);
    SRGrammar.CmdSetRuleIdState(0, SGDSActive);

    FWinAmp := TWinampApi.Create( txtWinAmp.Text );

    // schrijf terug naar ini file:
    FIniFile.WriteString( 'Eddie', 'MP3s', txtMP3s.Text );
    FIniFile.WriteString( 'Eddie', 'WinAmp', txtWinAmp.Text );
end;

procedure TForm1.SpSharedRecoContext1Recognition(Sender: TObject;
  StreamNumber: Integer; StreamPosition: OleVariant;
  RecognitionType: TOleEnum; var Result: OleVariant);
var
    str : String;
    Res, P : Integer;
    SR : TSearchRec;
    I : Integer;

begin
    str := Result.PhraseInfo.GetText();
    P := Pos( ' ', str );
    if P<=0 then Exit;
    // verwijder beginnende eddie
    str := Copy( str, P+1, Length(str) );

    lblLastCommand.Caption := str;
    // probeer eerst de winamp commando's
    if str = kwacPlay then begin
        FWinAmp.Play;
        Speak( 'playing' );
    end else if str = kwacStop then begin
        FWinAmp.Stop;
        Speak( 'stopping' );
    end else if str = kwacPause then begin
        FWinAmp.Pause;
        Speak( 'pausing' );
    end else if str = kwacVolUp then begin
        Speak( 'volume turned up' );
        for I := 0 to kVolumeSteps do FWinAmp.VolumeUp;
    end else if str = kwacVolDn then begin
        Speak( 'volume turned down' );
        for I := 0 to kVolumeSteps do FWinAmp.VolumeDown;
    end else begin
        // okay, geen winamp commando, dus een select.
        P := Pos( ' ', str );
        if P>0 then begin
            str := Copy( str, P+1, Length(str) );
            // verwijder alles voor de eerste spatie
            str := FsSongDir+'\'+str;
            // maak er een directory van
            Res := FindFirst( str+'\*.mp3', faAnyFile, SR );
            while Res = 0 do begin
                // gebruik AddToPlayList om dit liedje te spelen
                FWinAmp.AddToPlayList( str + '\' + SR.Name );
                Res := FindNext( SR );
            end;
            FindClose( SR );
            Speak( str + ' has been queued' );
        end;
    end;
end;


procedure TForm1.Speak(Str: String);
begin
    SpVoice1.Speak(Str, SVSFDefault);
end;

procedure TForm1.butTrainClick(Sender: TObject);
var
    U : OleVariant;
begin
    SpSharedRecoContext1.Recognizer.DisplayUI(Handle, 'Train', 'UserTraining', U)
end;

procedure TForm1.butMicrofoonClick(Sender: TObject);
var
    U : OleVariant;
begin
    SpSharedRecoContext1.Recognizer.DisplayUI(Handle, 'Microphone training', 'MicTraining', U)
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
    FIniFile := TIniFile.Create( 'WIN.INI' );
    txtMP3s.Text := FIniFile.ReadString( 'Eddie', 'MP3s', 'C:\Songs' );
    txtWinAmp.Text := FIniFile.ReadString( 'Eddie', 'WinAmp', 'C:\Program Files\WinAmp' );
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    if Assigned(FWinAmp) then
        FWinAmp.Free;
    FIniFile.Free;
end;

end.

