# Sample code for speech recognition using the MS Speech API
# Inigo Surguy (inigosurguy@hotmail.com)
from win32com.client import constants
import win32com.client
import pythoncom
import WinAmp
import time, os

songpath=r'D:\songs'

"""Sample code for using the Microsoft Speech SDK 5.1 via COM in Python.
    Requires that the SDK be installed (it's a free download from
            http://www.microsoft.com/speech
    and that MakePy has been used on it (in PythonWin,
    select Tools | COM MakePy Utility | Microsoft Speech Object Library 5.1).

    After running this, then saying "One", "Two", "Three" or "Four" should
    display "You said One" etc on the console. The recognition can be a bit
    shaky at first until you've trained it (via the Speech entry in the Windows
    Control Panel."""
class SpeechRecognition:
    """ Initialize the speech recognition with the passed in list of words """
    def __init__(self, wordsToAdd, winamp):
        # For text-to-speech
        self.speaker = win32com.client.Dispatch("SAPI.SpVoice")
        # For speech recognition - first create a listener
        self.listener = win32com.client.Dispatch("SAPI.SpSharedRecognizer")
        # Then a recognition context
        self.context = self.listener.CreateRecoContext()
        # which has an associated grammar
        self.grammar = self.context.CreateGrammar()
        # Do not allow free word recognition - only command and control
        # recognizing the words in the grammar only
        self.grammar.DictationSetState(0)
        # Create a new rule for the grammar, that is top level (so it begins
        # a recognition) and dynamic (ie we can change it at runtime)
        self.wordsRule = self.grammar.Rules.Add("wordsRule",
                        constants.SRATopLevel + constants.SRADynamic, 0)
        # Clear the rule (not necessary first time, but if we're changing it
        # dynamically then it's useful)
        self.wordsRule.Clear()
        # And go through the list of words, adding each to the rule
        [ self.wordsRule.InitialState.AddWordTransition(None, word) for word in wordsToAdd ]
        # Set the wordsRule to be active
        self.grammar.Rules.Commit()
        self.grammar.CmdSetRuleState("wordsRule", 1)
        # Commit the changes to the grammar
        self.grammar.Rules.Commit()
        # And add an event handler that's called back when recognition occurs
        self.eventHandler = ContextEvents(self.context, winamp)
        # Announce we've started
        self.say("Started successfully")
    """Speak a word or phrase"""
    def say(self, phrase):
        self.speaker.Speak(phrase)


"""The callback class that handles the events raised by the speech object.
    See "Automation | SpSharedRecoContext (Events)" in the MS Speech SDK
    online help for documentation of the other events supported. """
class ContextEvents(win32com.client.getevents("SAPI.SpSharedRecoContext")):
    """Called when a word/phrase is successfully recognized  -
        ie it is found in a currently open grammar with a sufficiently high
        confidence"""
    def __init__(self, context, winamp):
        win32com.client.getevents("SAPI.SpSharedRecoContext").__init__(self, context)
        self.winamp=winamp

    def OnRecognition(self, StreamNumber, StreamPosition, RecognitionType, Result):
        newResult = win32com.client.Dispatch(Result)
        txt = newResult.PhraseInfo.GetText()
        words=txt.split(' ')
        if words[0]!='eddie': return
        if len(words)==2 and words[1] in self.winamp.winamp_commands:
            self.winamp.command( words[1] )
            print 'winamp: ', words[1]
        else:
            if words[1]=='select' or words[1]=='queue': # select a band
                dir = os.path.join( songpath, ' '.join(words[2:]) )
                if words[1]=='select':
                    self.winamp.usercommand( 101 )
                print 'songs in ', dir, os.listdir(dir)
                for song in os.listdir( dir ):
                    song=song.lower()
                    if song.endswith( '.mp3' ):
                        print 'adding '+ os.path.join( dir, song )
                        try:
                            self.winamp.addToPlayList( os.path.join( dir, song ) )
                        except:
                            print 'error'
                if words[1]=='select':
                    self.winamp.command( 'play' )
    
if __name__=='__main__':
    
    w = WinAmp.winamp( r'C:\Program Files\Winamp')
    # add the winamp commands:
    wordsToAdd = ['eddie '+command for command in w.winamp_commands]
    # add the bands:
    for f in os.listdir( songpath ):
        if os.path.isdir( os.path.join( songpath, f) ):
            wordsToAdd.append( 'eddie select '+f )
    print wordsToAdd
    speechReco = SpeechRecognition(wordsToAdd,w)
    while 1:
        pythoncom.PumpWaitingMessages()



