unit WinAmp23;
// WinAmp remote control unit works with WinAmp 1x, 2x and 3x
// might even work with Sonique MP3 player
// one might consider embedding the whole thing
// in an object, but then there can only be one instance
// so what is the point.
//
// (c) Douwe Osinga 2003. If you want me to make this
// open source, improve the code and send me an email.
// douwe@oberon.nl


interface

procedure SetWinAmpPath( sPath : String );
procedure PlayFile( FN : String );
procedure QueueFile( FN : String );
procedure SendCommand( sCommand : String );
procedure Next;
procedure Prev;
procedure VolumeUp;
procedure VolumeDown;
procedure Stop;
procedure Pause;
procedure Play;

implementation

uses
    Windows, Messages;

type
    TPlayerControl = record
        Command : String;
        WA3  : Char;
        WA2  : Integer;
    end;

const
    // commands contains the supported commands. Specify the WinAmp 2 message value in WA2
    // and the char to press in WA3. Note: Chars > 128 are literal scancodes + 128.
    Commands : array[0..6] of TPlayerControl = (
      (Command : 'next'; WA3 : 'b'; WA2 : 40048 ),
      (Command : 'prev'; WA3 : 'z'; WA2 : 40044 ),
      (Command : 'volumeup'; WA3 : #166; WA2 : 40058 ),
      (Command : 'volumedn'; WA3 : #168; WA2 : 40059 ),
      (Command : 'stop'; WA3 : 'v'; WA2 : 40047 ),
      (Command : 'pause'; WA3 : 'c'; WA2 : 40046 ),
      (Command : 'play'; WA3 : 'x'; WA2 : 40045 ) );


var
    sWinAmpPath : String;

// helper functions:

procedure SendChar( Window : THandle; chKey : Char );
var
    Key, ScanCode : Integer;
begin
    if chKey > #128 then begin
        ScanCode := Ord(chKey)-128;
        Key := ScanCode;
    end else begin
        Key := VkKeyScan(chKey);
        ScanCode := MapVirtualKey(Key, 0);
    end;
    PostMessage(Window, WM_KEYDOWN, Key, ScanCode);
    if Key<>0 then PostMessage(Window, WM_CHAR, Key,    ScanCode);
    PostMessage(Window, WM_KEYUP, Key,   ScanCode);
end;

// api

procedure SetWinAmpPath( sPath : String );
begin
    sWinAmpPath := sPath;
end;

procedure PlayFile( FN : String );
begin
  WinExec(PChar('"'+sWinampPath+'\winamp.exe" "'+FN+'"'),SW_SHOW);
end;

procedure QueueFile( FN : String );
begin
  WinExec(PChar('"'+sWinampPath+'\winamp.exe" /ADD "'+FN+'"'),SW_SHOW);
end;

procedure SendCommand( sCommand : String );
var
    WinAmp : THandle;
    WA2 : Integer;
    WA3 : Char;
    I : Integer;
begin
    WA2 := -1;
    WA3 := #0;
    for I := Low(Commands) to High(Commands) do begin
        if sCommand = Commands[I].Command then begin
            WA2 := Commands[I].WA2;
            WA3 := Commands[I].WA3;
            Break;
        end;
    end;

    WinAmp := FindWindow('Winamp v1.x', 0);
    // if we find the window and the command is implemented for WinAmp 2:
    if (WinAmp<>0) and (WA2<>0) then begin
        SendMessage( WinAmp, WM_COMMAND, WA2, 0 );
        Exit;
    end;

    WinAmp := FindWindow('Studio', 0);
    if WinAmp=0 then // Sonique has the same command, might as well implement them too:
    WinAmp := FindWindow('Sonique Window Class',0);
    if (WinAmp<>0) and (WA3<>#0) then begin
        SendChar( WinAmp, WA3 );
        Exit;
    end;
end;

procedure Next;
begin
    SendCommand( 'next' );
end;

procedure Prev;
begin
    SendCommand( 'prev' );
end;

procedure VolumeUp;
begin
    SendCommand( 'volumeup' );
end;

procedure VolumeDown;
begin
    SendCommand( 'volumedn' );
end;

procedure Stop;
begin
    SendCommand( 'stop' );
end;

procedure Pause;
begin
    SendCommand( 'pause' );
end;

procedure Play;
begin
    SendCommand( 'play' );
end;

end.
