unit fMain;

interface

// Vendian by Douwe Osinga, http://douweosinga.com
// (c) 2002,2003. I will release the source code under GPL as soon as
// I receive an interesting addition.

uses
  Windows, Classes, ExtCtrls, Messages, ShellApi,
  SysUtils, Graphics, Controls, Forms, Dialogs,  StdCtrls,
  uConst, uWorld, uProgram, uAnimal;

const
    kAnimalCountAtStart = 80;
    kScrollDist = 10;
    kZoomPerc = 20;

type
  TfrmVendian = class(TForm)
    timerStart: TTimer;
    memHerbivoor: TMemo;
    panInfo: TPanel;
    lblUrl: TLabel;
    lblAnimalCount: TLabel;
    lblGeneration: TLabel;
    lblWhatsGoingOn: TLabel;
    procedure timerStartTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure lblUrlClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    { Public declarations }
    FClosed : Boolean;
    World : TWorld;
    FPaused : Boolean;
    FScale : Double;
    FXOffs, FYOffs : Integer;
    FGenes : TList;
  end;

var
  frmVendian: TfrmVendian;

implementation

{$R *.DFM}

procedure TfrmVendian.timerStartTimer(Sender: TObject);
var
    I,J : Integer;
    BM : TBitmap;
    Red,Blue,Green, X,Y : Integer;
    X1,Y1 : Integer;
    dX,dY : Integer;
    Scale : Double;
    iGenCount : Integer;
    Marker : TColor;
    Lines : array[0..kMaxY*3-1] of PByteArray;
    W, H : Integer;
    slGene,slLogs : TStringList;
    An : TAnimal;
    TotalEnergy : Integer;
    WHandle, DC : THandle;
begin
    timerStart.Enabled := False;
    FGenes := TList.Create;
    FGenes.Clear;
    slLogs := TStringList.Create;
    FindFiles( 'log\*.txt', faAnyFile, slLogs );
    for I := 0 to slLogs.Count-1 do begin
        slGene := TStringList.Create;
        slGene.LoadFromFile('log\'+slLogs[I]);
        FGenes.Add( slGene );
    end;
   // FGenes.Clear;
    FGenes.Add( memHerbivoor.Lines );

    World := TWorld.Create;
    for I :=0 to kAnimalCountAtStart do begin
        J := Random(FGenes.Count);
        An := World.CreateAnimal( TStrings( FGenes[J]) );
    end;
    BM := TBitmap.Create;
    BM.Width := kMaxX*3+1;
    BM.Height := kMaxY*3+1;
    FScale := 1.0;
    BM.HandleType := bmDIB;
    BM.PixelFormat := pf24Bit;
    for Y := 0 to kMaxY*3-1 do
        Lines[Y] := BM.ScanLine[Y];

    iGenCount := 0;
    repeat
         Inc(iGenCount);
         if not FPaused then World.Cycle;
         if iGenCount mod kShowFrameCount = 0 then begin
             TotalEnergy := 0;
             for X:=0 to kMaxX-1 do begin
                 for Y:=0 to kMaxY-1 do begin
                     if World.FGrid[X,Y].FFood=-1 then begin
                         Red   := 180;
                         Blue  := 180;
                         Green := 180;
                     end else if (World.FGrid[X,Y].FAnimal<>nil) and (World.FGrid[X,Y].FAnimal.FMarker<>clBlack) then begin
                         Marker := World.FGrid[X,Y].FAnimal.FMarker;
                         Red   := (Marker shr 16) and 255;
                         Blue  := (Marker shr 08) and 255;
                         Green := (Marker shr 00) and 255;
                     end else if World.FGrid[X,Y].FFood>kMaxPlant then begin
                         Red := 128;
                         Blue := 128;
                         Green := 255;
                     end else begin
                         Red := 64-((64 * World.FGrid[X,Y].FFood) div kMaxPlant);
                         Blue := 0;
                         Green := 64+((191 * World.FGrid[X,Y].FFood) div kMaxPlant);
                     end;
                     for X1:=X*3 to X*3+2 do begin
                         for Y1:=Y*3 to Y*3+2 do begin
                             Lines[Y1][X1*3+0] := Blue;
                             Lines[Y1][X1*3+1] := Green;
                             Lines[Y1][X1*3+2] := Red;
                         end;
                     end;
                     if World.FGrid[X,Y].FAnimal<>nil then with World.FGrid[X,Y].FAnimal do begin
                         Inc( TotalEnergy, FEnergy );
                         X1 := X*3+1;
                         Y1 := Y*3+1;
                         if FEnergy>200 then
                             Scale := 1.0
                         else
                             Scale := FEnergy/200;
                         Red  := Round( Color*Scale );
                         Blue := Round( (255-Color)*Scale );
                         Lines[Y1][X1*3+0] := Blue;
                         Lines[Y1][X1*3+1] := 0;
                         Lines[Y1][X1*3+2] := Red;

                         // nose
                         dX := FdX;
                         dY := FdY;
                         Lines[Y1+dY][3*(X1+dX)+0] := Blue;
                         Lines[Y1+dY][3*(X1+dX)+1] := 0;
                         Lines[Y1+dY][3*(X1+dX)+2] := Red;

                         // Achter Links
                         Lines[Y1-dY-dX][3*(X1+dY-dX)+0] := Blue;
                         Lines[Y1-dY-dX][3*(X1+dY-dX)+1] := 0;
                         Lines[Y1-dY-dX][3*(X1+dY-dX)+2] := Red;

                         // Achter Rechts
                         Lines[Y1-dY+dX][3*(X1-dY-dX)+0] := Blue;
                         Lines[Y1-dY+dX][3*(X1-dY-dX)+1] := 0;
                         Lines[Y1-dY+dX][3*(X1-dY-dX)+2] := Red;
                     end;
                 end;
             end;
             DC := GetDC(Handle);
             BitBlt( DC,0,0,BM.Width,BM.Height,
                     BM.Canvas.Handle, 0,0,SRCCOPY );
             ReleaseDC(Handle,DC);

(*             W := Screen.Width;
             H := Screen.Height;
             WHandle := Handle;
             DC := GetDC(WHandle);
             StretchBlt( DC,0,0,W,H,
                         BM.Canvas.Handle, 0,0,BM.Width,BM.Height,SRCCOPY );
             ReleaseDC(WHandle,DC);
*)

             lblAnimalCount.Caption := 'Animal count:'+IntToStr(World.FAnimalList.Count);
             lblGeneration.Caption := 'Generation:' + IntToStr(World.GenCount);
         end;
         Application.ProcessMessages;
    until FClosed;
    World.Free;
end;


procedure TfrmVendian.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
    FClosed := True;
end;

procedure TfrmVendian.lblUrlClick(Sender: TObject);
begin
    ShellExecute( Handle, 'open', PChar(lblUrl.Caption), nil, nil, SW_SHOW );
end;

procedure TfrmVendian.FormCreate(Sender: TObject);
begin
    ClientWidth := kMaxX*3+1;
    ClientHeight := kMaxY*3+1 + panInfo.Height;
    lblUrl.Left := ClientWidth - lblUrl.Width - 10;
    lblWhatsGoingOn.Left := lblUrl.Left -lblWhatsGoingOn.Width - 10;
end;

end.
