unit uProgram;


interface

uses Classes, SysUtils, uConst, FileCtrl;



type
    TMnomic = record
       Name : String;
       Cost : Integer
    end;

const
    kMaxInstruction=23;
    kMnomics : array[0..kMaxInstruction-1] of String = (
        'MoveForward',
        'MoveBackward',
        'TurnLeft',
        'TurnRight',
        'TurnRandom',
        'Smell',
        'Fork',
        'Eat',
        'TestFood',
        'TestAnimal',
        'TestObstacle',
        'BrancheNonEqual',
        'BrancheGreater',
        'AddRegs',
        'SubsRegs',
        'MultRegs',
        'DivRegs',
        'LoadConst',
        'LoadReg',
        'Jump',
        'Loop',
        'LoadEnergy',
        'Hit' );

    kParamCount : array[0..kMaxInstruction-1] of Integer = (
        0,
        0,
        0,
        0,
        0,
        3,
        1,
        0,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        2,
        2,
        1,
        2,
        1,
        1 );

type
    TInstruction = record
       Operation : Integer;
       Param1, Param2, Param3 : Integer;
    end;
    TInstructions = array[0..0] of TInstruction;
    PInstructions = ^TInstructions;

    TProgram = class
       FSize : Integer;
       FInstructions : PInstructions;
       FColor : Integer;
       constructor Compile( slProgram : TStrings );
       constructor Copy( FromProgram : TProgram );
       destructor Destroy; override;
       procedure CompileInstruction( Str : String; var AnInstruction : TInstruction );
       function DeCompile : String;
       procedure SaveToFile( sPath : String );
       procedure CalculateColor;
       procedure Mutate;
    end;


implementation

{ TProgram }

constructor TProgram.Compile(slProgram: TStrings);
var
    I : Integer;
begin
    for I := slProgram.Count-1 downto 0 do begin
        if Trim(slProgram[I])='' then
            slProgram.Delete(I);
    end;
    FSize := slProgram.Count;
    GetMem( FInstructions, SizeOf(TInstruction)*FSize );
    for I := 0 to FSize-1 do begin
        CompileInstruction( slProgram[I], FInstructions^[I] );
    end;
    CalculateColor;
end;

constructor TProgram.Copy(FromProgram: TProgram);
begin
    FSize := FromProgram.FSize;
    GetMem( FInstructions, SizeOf(TInstruction)*FSize );
    Move( FromProgram.FInstructions^, FInstructions^, SizeOf(TInstruction)*FSize );
    if Random(kMutateChange)=0 then
        Mutate;
    CalculateColor;
end;

procedure TProgram.CompileInstruction(Str: String; var AnInstruction: TInstruction);
var
    sOperation : String;
    Idx,I : Integer;
    I1,I2 : Integer;

    function StrInt(Str : String) : Integer;
    begin
        if Trim(Str)='' then
            Result := 0
        else
            Result := StrToInt(Str);
    end;
begin
    FillChar( AnInstruction, SizeOf(AnInstruction), #0);
    I1 := Pos(',',Str);
    I2 := Pos(' ',Str);
    if (I1<>0) and ( (I1<I2) or (I2=0)) then
       Str[I1] := ' ';
       
    sOperation := ExtractTo(Str,' ');
    Idx := -1;
    for I:=Low(kMnomics) to High(kMnomics) do begin
        if TextEqual(kMnomics[I], sOperation) then begin
            Idx:=I;
            Break;
        end;
    end;
    if Idx=-1 then
        raise Exception.Create( sOperation + ' is not a valid instruction');
    with AnInstruction do begin
        Operation:=Idx;
        Param1:=StrInt(ExtractTo(Str,','));
        Param2:=StrInt(ExtractTo(Str,','));
        Param3:=StrInt(ExtractTo(Str,','));
    end;
end;


destructor TProgram.Destroy;
begin
    FreeMem( FInstructions );
    inherited;
end;

procedure TProgram.CalculateColor;
var
    I, I1,I2,I3,I4 : Integer;
begin
    I1:=0;
    I2:=0;
    I3:=0;
    I4:=0;
    for I := 0 to FSize-1 do begin
        Inc(I1, FInstructions^[I].Operation and 255);
        Inc(I2, FInstructions^[I].Param1 and 255);
        Inc(I3, FInstructions^[I].Param1 and 255);
        Inc(I4, FInstructions^[I].Param1 and 255);
    end;
    FColor := ((I1 and 255) shl 24) + ((I2 and 255) shl 8) + ((I3 and 255) shl 16) + ((I4 and 255))
end;

procedure TProgram.Mutate;
    procedure Modify( var I : Integer );
    var
        P : Integer;
    begin
        case Random(100) of
            00..34: Dec(I);
            35..69: Inc(I);
            70..84: begin
                        P := random(35);
                        I := Round( I / (1+P/100));
                    end;
            85..99: begin
                        P := random(35);
                        I := Round( I * (1+P/100));
                    end;
        end;
    end;
var
    NewInstructions : PInstructions;
    First,Last,Size : Integer;
    I : Integer;
begin
    if Random(100)=0 then begin
        if not DirectoryExists('log') then
            MkDir('log');
        SaveToFile('log\gen'+IntToStr(100+Random(900))+'.txt' );
    end;

    // First determine what should happen:
    case Random(100) of
       00..70 : // Change random paramer
              begin
                  case Random(3) of
                    0:Modify(FInstructions^[Random(FSize)].Param1);
                    1:Modify(FInstructions^[Random(FSize)].Param2);
                    2:Modify(FInstructions^[Random(FSize)].Param3);
                  end
              end;
       71..85 : // Delete Instruction
              begin
                  First := Random(FSize);
                  GetMem(NewInstructions,SizeOf(TInstruction)*FSize);
                  FillChar(NewInstructions^,SizeOf(TInstruction)*FSize,#0 );
                  for I:=0 to First-1 do
                      NewInstructions^[I] := FInstructions^[I];
                  for I:=First+1 to FSize-1 do
                      NewInstructions^[I-1] := FInstructions^[I];
                  FreeMem(FInstructions);
                  FInstructions:=NewInstructions;
                  Dec(FSize);
              end;
       86..94 : // Duplicate Program piece
              begin
                  First := Random(FSize);
                  if First=FSize-1 then
                      Last := First
                  else begin
                      Size := FSize-First;
                      if Size>45 then Size := 45;
                      Last := First + Random(Size);
                  end;
                  Size := Last-First+1;
                  GetMem(NewInstructions,SizeOf(TInstruction)*(FSize+Size));
                  FillChar(NewInstructions^,SizeOf(TInstruction)*(FSize+Size),#0 );
                  for I:=0 to Last do
                      NewInstructions^[I] := FInstructions^[I];
                  for I:=First to Last do
                      NewInstructions^[I+Size] := FInstructions^[I];
                  for I:=Last+1 to FSize+Size-1 do
                      NewInstructions^[I] := FInstructions^[I-Size];
                  FreeMem(FInstructions);
                  FInstructions:=NewInstructions;
                  Inc(FSize,Size);
              end;
       95..97 : // Random new instruction
              begin
                  First := Random(FSize);
                  GetMem(NewInstructions,SizeOf(TInstruction)*(FSize+1));
                  for I:=0 to First do
                      NewInstructions^[I] := FInstructions^[I];
                  NewInstructions^[First+1].Operation := Random(kMaxInstruction);
                  NewInstructions^[First+1].Param1 := Random(256);
                  NewInstructions^[First+1].Param2 := Random(256);
                  NewInstructions^[First+1].Param3 := Random(256);
                  for I:=First+1 to FSize-1 do
                      NewInstructions^[I+1] := FInstructions^[I];
                  FreeMem(FInstructions);
                  FInstructions:=NewInstructions;
                  Inc(FSize,1);
              end;
       98..99 : // Change Instruction
              begin
                  FInstructions^[Random(FSize)].Operation := Random(kMaxInstruction);
              end;
       end;
end;

function TProgram.DeCompile: String;
var
    S : String;
    I : Integer;
    function ParamStr(Sep : String; Val : Integer) : string;
    begin
        Result := Sep + IntToStr(Val);
    end;
begin
    S := '';
    for I := 0 to FSize-1 do begin
        S := S +kMnomics[FInstructions^[I].Operation];
        if kParamCount[FInstructions^[I].Operation]>0 then
            S := S +ParamStr(' ',FInstructions^[I].Param1);
        if kParamCount[FInstructions^[I].Operation]>1 then
            S := S +ParamStr(',',FInstructions^[I].Param2);
        if kParamCount[FInstructions^[I].Operation]>2 then
            S := S +ParamStr(',',FInstructions^[I].Param3);
        S := S + #13
    end;
    Result := AdjustLineBreaks(S);
end;

procedure TProgram.SaveToFile(sPath: String);
var
    SL : TStringList;
begin
    SL := TStringList.Create;
    SL.Add( Decompile );
    SL.SaveToFIle(sPath);
    SL.Free;
end;

end.
